﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true"
    CodeBehind="TimeUseList.aspx.cs" Inherits="GUI.Pages.TimeUseList" %>

<%@ Register TagPrefix="uc" TagName="ProjectNavTest" Src="~/Controls/ProjectNavTest.ascx" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:ProjectNavTest ID="ProjectNavTest" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
       <asp:HiddenField ID="hdnDeletePitanje" runat="server"/>
        <asp:HiddenField ID="hdnDeleteIndeks" runat="server"/>
      <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="portlet light bordered light-blue kendo-form">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_Time %>" /> </span>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        <div class="form-body">
                              <div class="row">
                                    <div class="col-md-6 left">
                                           <asp:Button OnClick="btnNewClick" runat="server" ID="btnNew" CssClass="btn blue" Text="<%$ Resources:ProjectManagementUI, UI_NewTimeUse %>" CausesValidation="false" />
                                    </div>
                                    <div class="col-md-6 right text-right">
                                         <asp:Button ID="btnPdf" OnClick="BtnPdfClick" CssClass="btn red" Text="Export PDF"
                                        runat="server" />
                                        <asp:Button ID="btnExcel" OnClick="BtnExcelClick" CssClass="btn red" Text="Export Excel"
                                        runat="server" />
                                        <asp:Button ID="btnWord" OnClick="BtnWordClick" CssClass="btn red" Text="Export Word"
                                        runat="server" />
                                    </div>
                                </div>
                              <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1"
                                    ClientEvents-OnRequestStart="pnlRequestStarted">
                                <div class="row">
                                    <div class="col-md-12 text-center">
                                        <div class="number">
                                           <small class="uppercase"><asp:Label runat="server" ID="lblUnpayable" /></small> - <small class="uppercase"><asp:Label runat="server" ID="lblPayable" /></small> -  <small class="uppercase"><asp:Label runat="server" ID="lblTotal" /></small>
                                        </div>
                                    </div>
                                </div>
                                <br />
                                                           
                                            <telerik:RadGrid Skin="Bootstrap" OnGridExporting="OnGridExporting" ID="grdTimeUseList" runat="server"
                                                PageSize="15" AllowFilteringByColumn="true" OnItemCommand="grdTimeUseList_OnItemCommand"
                                                AllowPaging="true" AllowSorting="true" OnNeedDataSource="grdTimeUseList_OnNeedDataSource"
                                                ShowFooter="True" OnItemDataBound="grdTimeUseList_ItemDataBound" CssClass="kendo-table">
                                                <GroupingSettings CaseSensitive="false" />
                                                <PagerStyle Mode="NextPrevAndNumeric" />
                                                <MasterTableView ShowHeadersWhenNoRecords="true" TableLayout="Auto" ShowFooter="False"
                                                    AutoGenerateColumns="False" DataKeyNames="Id">
                                                    <Columns>
                                                        <telerik:GridBoundColumn UniqueName="ActivityColumn" AutoPostBackOnFilter="true"
                                                            CurrentFilterFunction="Contains" SortExpression="Activity.Name" ShowFilterIcon="false"
                                                            HeaderText="<%$ Resources:ProjectManagementUI, Common_Activity %>" DataField="Activity.Name" />
                                                        <telerik:GridBoundColumn UniqueName="UserColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                                                            SortExpression="User.Name" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_User %>" DataField="User.Name" />
                                                        <telerik:GridBoundColumn UniqueName="DateColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="EqualTo"
                                                            SortExpression="TimeUseDate" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Date %>" DataField="TimeUseDateLocalized" />
                                                        <telerik:GridBoundColumn UniqueName="DescritpionColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                                                            SortExpression="Description" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Description %>" DataField="Description" />
                                                        <telerik:GridBoundColumn UniqueName="SpentTimeColumn" AutoPostBackOnFilter="true"
                                                            CurrentFilterFunction="Contains" SortExpression="SpentTime" ShowFilterIcon="false"
                                                            HeaderText="<%$ Resources:ProjectManagementUI, TimeUse_UsedTime %>" DataField="SpentTime" />
                                                        <telerik:GridBoundColumn UniqueName="PayableColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="EqualTo"
                                                            SortExpression="IsPayableDisplay" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, TimeUse_Chargeable %>" DataField="IsPayableDisplay" />
                                                        <telerik:GridBoundColumn UniqueName="AmountColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="EqualTo"
                                                            SortExpression="Amount" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Amount1 %>" DataField="Amount" />
                                                        <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderText=""
                                                            ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ButtonCssClass="btn btn-sm red">
                                                             <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                                        </telerik:GridButtonColumn>
                                                        <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" HeaderText=""
                                                            ButtonCssClass="btn btn-sm blue" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Choose %>">
                                                             <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                                        </telerik:GridButtonColumn>
                                                    </Columns>
                                                </MasterTableView>
                                            </telerik:RadGrid>
                                                                              <telerik:RadWindowManager ID="RadWindowManager1" runat="server">
                </telerik:RadWindowManager>  
<telerik:RadScriptBlock runat="server" ID="RadScriptBlock1">
<script type="text/javascript">
              function updateRowId(arg) {
                  var rowId = document.getElementsByName("ctl00$ctl00$ctl00$MainContentPlaceHolder$Content$FormPlaceHolder$hdnDeleteIndeks");
               rowId[0].setAttribute("value", arg);
               //alert(rowId[0].getAttribute("value"));
              }
             
    function updatePitanjeId(arg) {
       
        var pitanje = document.getElementsByName("ctl00$ctl00$ctl00$MainContentPlaceHolder$Content$FormPlaceHolder$hdnDeletePitanje");
        pitanje[0].setAttribute("value", arg);
                     }
             function confirmCallBackFn(arg) {
                 var pitanje = document.getElementsByName("ctl00$ctl00$ctl00$MainContentPlaceHolder$Content$FormPlaceHolder$hdnDeletePitanje");
                
                 var rowId = document.getElementsByName("ctl00$ctl00$ctl00$MainContentPlaceHolder$Content$FormPlaceHolder$hdnDeleteIndeks")[0].getAttribute("value");
                 
                 //alert(rowId);
                if (arg == true) {
                  var masterTable = $find("<%= grdTimeUseList.ClientID%>").get_masterTableView();
                    pitanje[0].setAttribute("value", "Pitao");
                    masterTable.fireCommand("Delete", rowId);

                }
                else {
                    pitanje[0].setAttribute("value", "Nece");
                    
                }
             }

                                                    </script>
    </telerik:RadScriptBlock>
                                </telerik:RadAjaxPanel>
                            <telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1">
                                <div class="updatePanelProgress">
                                    <asp:Literal ID="ltrPLeaseWait" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
                            </telerik:RadAjaxLoadingPanel>

                        </div>
                    </div>
                </div>
            </div>
        </div>

</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="ScriptPlacerholder" runat="server">
    <script type="text/javascript">
        function pnlRequestStarted(ajaxPanel, eventArgs) {
            if (eventArgs.EventTarget.indexOf("btnPdf") > 0 ||
            eventArgs.EventTarget.indexOf("btnExcel") > 0 ||
            eventArgs.EventTarget.indexOf("btnWord") > 0) {
                eventArgs.EnableAjax = false;
            }
        }
    </script>
</asp:Content>